#!/bin/sh -e
#             rpfj 1.0  -  Copyright (C) 2015 Andrea Remondini           
#
#                        RatPoison Frameset Juggler
#
#   This program is free software: you can redistribute it and/or modify
#   it  under  the terms  of the  GNU General Public License  version 2,
#   as published by the Free Software Foundation.
#    
#   This program is distributed in the hope that it will be useful,  but
#   WITHOUT  ANY  WARRANTY;    without  even  the  implied  warranty  of
#   MERCHANTABILITY  or  FITNESS  FOR  A  PARTICULAR  PURPOSE.   See the
#   GNU General Public License for more details.
#
#   You should  have received  a copy of the  GNU General Public License
#   along with this program. If not, see <http://www.gnu.org/licenses/>.

#   $Id: rpfj.sh 24 2015-08-14 09:10:34Z ndr $

unset message info
RATPOISON="`which ratpoison` -c"
set +e
exitCode=0

pickMemFile()			# pick a suitable memory file name/location,
{				# for frameset dumping & loading
	if [ -d ~/etc ] && [ -w ~/etc ]; then
		memFile="$HOME/etc/rpfj.dat"
	else
		memFile="$HOME/.rpfj"
	fi
}

#---------------------------------------------------------- COMMAND LINE PARSING

TEMP=`getopt -o qg::s::idhlV -n rpfj -- "$@"`
if [ $? -gt 0 ]; then
	"$0" -h
	exit 64
fi

eval set -- "$TEMP"
while true ; do
 framePtr=`$RATPOISON 'getenv rpfjfp'`
 oldPtr=`$RATPOISON 'getenv rpfjop'`
 case "$1" in
	-q)
		quiet=y
		shift ;;

	-s)							# Store
		dest=${2:-${framePtr:-1}} # destination = $2. If $2 is unset,
					  # destination=framepointer (i.e.:
					  # update current frameset); if
					  # framepointer is unset, destination=1

		$RATPOISON "setenv rpfj$dest `$RATPOISON sfdump`"
		message="$message Stored frameset ${dest}."
		shift 2 ;;

	-g)							# Go
		 # without an argument, '-g' ping-pongs
		 # between the last 2 selected framesets 
		tempPtr=${framePtr:-1}
		framePtr=${2:-${oldPtr:-1}}
		oldPtr=$tempPtr
		$RATPOISON "setenv rpfjfp $framePtr" \
			  -c "setenv rpfjop $oldPtr" \
			  -c "sfrestore `$RATPOISON 'getenv rpfj'$framePtr`"
		info=y
		shift 2 ;;

	-l)							# Load
		pickMemFile
		if [ ! -e "$memFile" ] || [ ! -r "$memFile" ]; then
			 # if rpfj's memory file is missing or unreadable,
			 # init ratpoison's environment with standard frameset
			 # pointers. This should always be done at ratpoison's
			 # startup, if you use rpfj
			$RATPOISON 'setenv rpfjfp 1' -c 'setenv rpfjop 1'
		else
			$RATPOISON "source $memFile"
			# save op (old pointer, to the previously selected FS)
			oldPtr=`$RATPOISON 'getenv rpfjop'`
			# because this overwrites it while switching to FS *fp
			"$0" -qg`$RATPOISON 'getenv rpfjfp'`
			# restore op:
			$RATPOISON "setenv rpfjop $oldPtr"
		fi
		shift ;;

	-d)							# Dump
		pickMemFile
		cat /dev/null > "$memFile"
		if [ $? -gt 0 ]; then
			$RATPOISON "echo Could not store framesets. \
			Make sure you have write permission on ${memFile%/*} \
			and $memFile"
			sleep 5		# makes sure message stays visible
			exitCode=73
		else
			for i in {{1..9},fp,op} ; do
				eval framesetDump=\$rpfj$i
				if [ -n "$framesetDump" ]; then
					echo "setenv rpfj$i $framesetDump" \
					>> "$memFile"
				fi
			done
		fi
		shift ;;

	-i)							# Info
		info=y
		shift ;;

	-V)							# Version
		sed -n '2s/^#//p' "$0" | tr -d '$'
		exit 0 ;;

	-h)							# Help
		sed -n '/^$/,$p' "$0" | sed 1d | gunzip -
		exit 0 ;;

	--)							# No more opts
		shift; break ;;
 esac
done
[ -n "$info" ]	&& message="$message Frameset $framePtr on screen."
[ -z "$quiet" ] && [ -n "$message" ] && $RATPOISON "echo $message"
exit $exitCode
