.\" rpfj man page  -  Copyright (C) 2015 Andrea Remondini
.\"
.\" $Id: rpfj.m4 25 2015-08-14 12:19:14Z ndr $
.\"
.\" Copying and distribution of this file, with or without modification,
.\" are permitted in any medium without royalty provided the copyright
.\" notice and this notice are preserved.  This file is offered as-is,
.\" without any warranty.
.\"
changequote({,})
define({NO_ARG},{\(em with no argument given \(em})

define({FJ},{
.nh
.BR rpfj $1
.hy
})

define({RP},{
.nh
.BR ratpoison $1
.hy
})

define({RP1},{
ifdef({HTML},
.UR http://www.nongnu.org/ratpoison/doc/
)
RP((1))
ifdef({HTML},
.UE
)
})

define({RPs},RP('s))

define({ENV},environment)
define({FS},frameset$1)
define({FSs},FS(s))
define({DF},data file)
define({DFSS},{DF (see section
.BR FILES ,
below).})

.\" Get rid of the stupid / ugly / useless UTF-8 angled brackets
.\" groff just loves to use by default:
.char \[la] <
.char \[ra] >

.TH RPFJ 1 esyscmd({echo '$Date: 2015-08-14 14:19:14 +0200 (Fri, 14 Aug 2015) $' |sed 's/^[^ ]* //;s/ .*//' |tr -d '\n'}) Ratpoison
.SH NAME 
rpfj \- RatPoison Frameset Juggler
.SH SYNOPSIS
.B  rpfj
.RB [ -d ]
.RB [ -g
.IR [id] ]
.RB [ -h ]
.RB [ -l ]
.RB [ -s
.IR [id] ]
.RB [ -V ]
.sp
.SH DESCRIPTION
FJ{}works with the RP1{}window manager to store and recall FSs, both
immediately and across sessions.
.SH OPTIONS
.TP
.B -d
Dump FSs 1 to 9 to FJ('s){}DFSS Dumping FSs with arbitrary names is not
supported: Single-digit names only, 1 to 9.
.TP
.BI -g [id]
Go to FS
.IR id ,
or NO_ARG to the formerly selected FS 
(ping-pong between the two most recently seen FSs).
.TP
.B -h
Display a usage summary and exit.
.TP
.B -i
Display the currently selected FS('s) number.
.TP
.B -l
Load FSs from FJ('s){}DFSS
.TP
.B -q
Quiet: the
.B -g
and
.B -s
options will not show a message on RPs{}bar.
.TP
.BI -s [id]
Store current FS to FS
.IR id ,
or NO_ARG to itself (thus updating the current FS).
.TP
.B -V
Print version information and exit.
.SH EXIT STATUS
.TP
.B 0
OK.
.TP
.B 1
RP{}not found in your
.IR $PATH .
.TP
.B 64
Command line usage error.
.TP
.B 73
Error while dumping FSs to FJ('s){}DFSS
.SH FILES
FJ{}will try to create and read its DF at one of the following
locations, in preferential order:
.TP
.I $HOME/etc/rpfj.dat
if $HOME/etc exists and is writable;
.TP
.I $HOME/.rpfj
if $HOME exists and is writable.
.P
Failing both attempts:
.IP \(bu 2
the
.B -d
option will simply give up dumping FSs to disk;
FJ{}will fail with error code 73 (see section
.BR EXIT\ STATUS ,
above);
.IP \(bu 2
the
.B -l
option will initialize RPs{}ENV with default FS pointers.
.SH NOTES
Option order matters:
.TP
.I rpfj\~-s\~-g2
will first store the current frameset into itself (i.e.: update it),
then switch to frameset
.IR 2 ;
.TP
.I rpfj\~-g2\~-s
will first switch to frameset
.IR 2 ,
then update it (which probably isn't very useful).
.SH BUGS
.IP \(bu 2
For performance reasons, no checks are performed on the argument passed
to options
.B -g
and
.BR -s .
Passing strange FS names containing spaces or other, non-alphanumeric
characters, will fail ungracefully;
.IP \(bu 2
FJ{}stores its FSs and pointers in RPs{}ENV, rudely overwriting
whatever variable might already live there, whose name collides
with FJ('s){}namespace. Such a collision would however be an
incredibly unlucky coincidence;
.IP \(bu 2
the
.B -d
option only works correctly if FJ{}is launched by
.nh
.BR ratpoison ,
.hy
because FJ{}needs to inherit RPs{}ENV in order to store
the FSs to its DF.
.P
Report actual bugs to the author:
.P
.RS 2
.nh
.MT andrea@\:andrearemondini.com
Andrea Remondini
.ME
.hy
.RE
.SH EXAMPLE
FJ('s)distribution directory contains a file called
.nh
.IR EXAMPLE.ratpoisonrc ,
.hy
which shows how to configure RP1{}for use with FJ(.)
A key combination
.nh
.RB ( Windows\ Key
+
.BR f )
.hy
is defined to enter, let's call it,
.IR FS\ mode .
A number key \(em\ 1\ to\ 9\ \(em pressed thereafter, will
switch to the corresponding FS.
.B Ctrl
+ 
.B number\ key
will store the current set of frames at that number. The 
.B a
key will recall the formerly selected FS. The
.B i
key will display information on which FS is currently on screen.
.P
Simply append said file, as it is, to your
.nh
.IR ~/.ratpoisonrc ,
.hy
or tweak it to taste.
.SH SEE ALSO
.P
.UR http://www.andrearemondini.com/sw/rpfj/
FJ('s){}web page
.UE ,
.RS
where the latest version is.
.RE
.TP
.I perldoc rpws
Type it at the shell prompt.
.B rpws
is a similar\(enbut\(endifferent utility, wherein RP('s){}windows
are assigned to workspaces. It's usually bundled with RP(.)
.TP
.BR ratpoison (1)
